<?php
/*************************************************************
 *
 * Copyright (c) 2023 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2023 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 0.0.1
 * Update 	: 2023.12.05
 *
 *************************************************************/
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: *');
header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");

if (!isset($_SERVER['HTTP_CHUNK_UUID'])) die('HTTP_CHUNK_UUID is required. ');
if (!isset($_SERVER['HTTP_CHUNK_COUNTER'])) die('HTTP_CHUNK_COUNTER is required. ');
if (!isset($_SERVER['HTTP_CHUNK_DENOMINATOR'])) die('HTTP_CHUNK_DENOMINATOR is required. ');


/***** アップロードディレクトリ *****/
$tempDir = sys_get_temp_dir() . "/{$_SERVER['HTTP_CHUNK_UUID']}/" ;


/**
 * ディレクトリを作成
 */
if (!is_dir($tempDir)) {
  @mkdir($tempDir, 0775);
  if (!is_dir($tempDir)) die(var_dump([ 'No such directory : '.$tempDir, __FILE__, __LINE__ ]));
  @chmod($tempDir, 0775);
};// END if


/**
 * 分割データの保存
 */
$fp = fopen($tempDir."chunk-" . $_SERVER['HTTP_CHUNK_COUNTER'], "w");
fputs($fp, file_get_contents('php://input'));
fclose($fp);
chmod($tempDir."chunk-" . $_SERVER['HTTP_CHUNK_COUNTER'], 0775);


/**
 * ファイル未完結
 */
if ($_SERVER['HTTP_CHUNK_COUNTER'] != $_SERVER['HTTP_CHUNK_DENOMINATOR']) {
  header("Content-Type: application/json; charset=utf-8");
  echo json_encode(['next'=>$_SERVER['HTTP_CHUNK_COUNTER'] + 1]);
  exit;
};// END if


/**
 * ファイル完結
 */
$tempFile = $tempDir.$_SERVER['HTTP_CHUNK_UUID'];
$fp = fopen($tempFile, "w");
for ($i=0; $i<=$_SERVER['HTTP_CHUNK_DENOMINATOR']; $i++) {
  $data = file_get_contents($tempDir."chunk-".$i);
  fputs($fp, $data);
  if (is_file($tempDir."chunk-".$i)) unlink($tempDir."chunk-".$i);
};// END for
fclose($fp);

header("Content-Type: application/json; charset=utf-8");
echo json_encode(['file'=>$tempFile]);
exit;
?>