;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	  : 2025.03.28
 *
 ************************************************************/
'use strict';
(() => {
  window.addEventListener('load', () => {
    vueClosure.ready();
  });
  
  /**
   * Vue
   */
  const vueClosure = (() => {
    return{
      vueApp: null,
      ready: () => {
        vueClosure.vueApp = vueClosure.create();
      },
      create: () => {
        return Vue.createApp({
          setup( ){
            const setNull = () => clickClosure.setNull();
            const setText = () => clickClosure.setText();
            const setLink = () => clickClosure.setLink();
            const setNotify = () => clickClosure.setNotify();
            const clearNotify = () => refNotify.value.clear();

            const refNotify = Vue.ref(null);

            const notifyObj = Vue.ref({
              'subject': "",
              'onclick': {
                'text': null,
                'linkObj': {
                  'href': null,
                  'target': "_blank"
                }
              }
            });


            const clickClosure = (() => {
              return {
                setNull: () => {
                  notifyObj.value.onclick.text = null;
                  notifyObj.value.onclick.linkObj.href = null;
                },
                setText: () => {
                  notifyObj.value.onclick.text = "";
                  notifyObj.value.onclick.linkObj.href = null;
                },
                setLink: () => {
                  notifyObj.value.onclick.text = null;
                  notifyObj.value.onclick.linkObj.href = "";
                },
                setNotify: () => {
                  refNotify.value.set(notifyObj.value.subject, "", Object.assign({}, JSON.parse(JSON.stringify(notifyObj.value.onclick))));
                  notifyObj.value.subject = "";
                  clickClosure.setNull();
                },
              };
            })();

            return {
              setNull,
              setText,
              setLink,
              setNotify,
              clearNotify,

              refNotify,

              notifyObj,
            };
          },
          components: {
            'compo-notify': Vue.defineAsyncComponent( () => window['vue3-sfc-loader']['loadModule']('./src/notify.vue', window['Vue3']['loaderOption']() ) ),
          }
        }).mount('#main');
      }
    }
  })();

})();