;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 0.0.2
 * Update	  : 2025.03.28
 *
 ************************************************************/
'use strict';
(() => {
  window.addEventListener('load', () => {
    vueClosure.ready();
  });
  
  /**
   * Vue
   */
  const vueClosure = (() => {
    return{
      vueApp: null,
      ready: () => {
        vueClosure.vueApp = vueClosure.create();
      },
      create: () => {
        return Vue.createApp({
          setup( ){
            const setNull = () => clickClosure.setNull();
            const setText = () => clickClosure.setText();
            const setLink = () => clickClosure.setLink();
            const setNotify = () => clickClosure.setNotify();

            const refNotify = Vue.ref(null);

            const notifyObj = Vue.ref({
              'subject': "",
              'onclick': {
                'text': null,
                'linkObj': {
                  'href': null,
                  'target': "_blank"
                }
              }
            });


            const clickClosure = (() => {
              return {
                setNull: () => {
                  notifyObj.value.onclick.text = null;
                  notifyObj.value.onclick.linkObj.href = null;
// TEST
notifyObj.value.subject = "注文情報を更新しました。";
                },
                setText: () => {
                  notifyObj.value.onclick.text = "";
                  notifyObj.value.onclick.linkObj.href = null;
// TEST
notifyObj.value.subject = "クリックでテキストを表示";
notifyObj.value.onclick.text = "内容を表示\n" + Date.now();
                },
                setLink: () => {
                  notifyObj.value.onclick.text = null;
                  notifyObj.value.onclick.linkObj.href = "";
// TEST
notifyObj.value.subject = "クリックでリンクを開く " + Date.now();
notifyObj.value.onclick.linkObj.href = "https://www.yahoo.co.jp";
                },
                setNotify: () => {
                  refNotify.value.set(notifyObj.value.subject, Object.assign({}, JSON.parse(JSON.stringify(notifyObj.value.onclick))));
                  notifyObj.value.subject = "";
                  clickClosure.setNull();
                },
              };
            })();


            return {
              setNull,
              setText,
              setLink,
              setNotify,

              refNotify,

              notifyObj,
            };
          },
          components: {
            'compo-notify': Vue.defineAsyncComponent( () => window['vue3-sfc-loader']['loadModule']('./components/notify/main.vue', window['Vue3']['loaderOption']() ) ),
          }
        }).mount('#main');
      }
    }
  })();

})();