;
/*************************************************************
 *
 * Copyright (c) 2024 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2024 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	  : 2024.08.23
 *
 ************************************************************/
'use strict';
(function(){
  window.addEventListener('DOMContentLoaded', () => {
    vueClosure.ready();
  });
  
  /**
   * Vue
   */
  const vueClosure = (() => {
    return{
      vueApp: null,
      ready: () => {
        vueClosure.vueApp = vueClosure.create();
      },
      create: () => {
        return Vue.createApp({
          setup() {
            const refMultiProcess = Vue.ref(null);

            /**
             * 非同期処理のサンプル
             */
            const sampleAsync = (ms, msg) => {
              return new Promise((resolve, reject) => {
                setTimeout(() => {
                  console.debug([ 'index.js', msg ]);
                  resolve(true);
                }, ms);
              });
            };

            /**
             * １つの非同期処理を行う
             */
            const singleTask = async () => {
              const process = [
                [
                  {
                    func: sampleAsync,
                    html: '非同期処理中です',
                    args: [1000, 'done']
                  },
                ],
              ];
              await refMultiProcess.value.execute(process);
              console.log('done');
            };


            /**
             * 直列で非同期処理を行う
             */
            const seriesProcess = () => {
              const process = [
                [
                  {
                    func: sampleAsync,
                    html: '非同期処理中です',
                    args: [2000, '2秒経過']
                  },
                  {
                    func: sampleAsync,
                    html: '2つ目処理中です',
                    args: [1000, '2秒 + 1秒経過']
                  },
                ],
              ];
              refMultiProcess.value.execute(process);
            };


            /**
             * 並列で非同期処理を行う
             */
            const parallelProcess = async () => {
              const process = [
                [
                  {
                    func: sampleAsync,
                    html: '2秒wait中',
                    args: [2000, '2秒経過']
                  },
                  {
                    func: sampleAsync,
                    html: '1秒wait中',
                    args: [1000, '2秒 + 1秒経過']
                  },
                ],
                [
                  {
                    func: sampleAsync,
                    html: '.5秒wait中',
                    args: [500, '.5秒経過']
                  },
                  {
                    func: sampleAsync,
                    html: '1秒wait中',
                    args: [1000, '.5秒 + 1秒経過']
                  },
                  {
                    func: sampleAsync,
                    html: '.5秒wait中',
                    args: [500, '.5秒 + 1秒 + .5秒経過']
                  },
                ],
              ];
              await refMultiProcess.value.execute(process);
              console.log('done');
            };
            

            return {
              refMultiProcess,
              singleTask,
              seriesProcess,
              parallelProcess,
            };
          },
          components: {
            'multi-process': Vue.defineAsyncComponent( () => window['vue3-sfc-loader']['loadModule']('./components/multi_process/main.vue', window['Vue3']['loaderOption']() ) ),
          }
        }).mount('#main');
      }
    }
  })();

})();