;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.2
 * Update	  : 2025.10.14
 *
 ************************************************************/
'use strict';

class Spinner {
  constructor () {
    this.id = null;
  }

  help() {
    let TXT = " ************************************************************\n";
    TXT += " *\n";
    TXT += " *  Copyright (c) 2025 ysrock Co., Ltd. <info@ysrock.co.jp>\n";
    TXT += " *  Copyright (c) 2025 Yasuo Sugano <sugano@ysrock.co.jp>\n";
    TXT += " *\n";
    TXT += " *  Version : 1.0.2\n";
    TXT += " *  update  : 2025.10.14\n";
    TXT += " *\n";
    TXT += " ************************************************************\n";
    TXT += " *\n";
    TXT += " *  スピナー\n";
    TXT += " *    const S = new Spinner()\n";
    TXT += " *\n";
    TXT += " ************************************************************\n";
    TXT += " *\n";
    TXT += " *  スピナーを表示\n";
    TXT += " *    S.show(inObj)\n";
    TXT += " *      @param {string} inObj.message? - 表示するメッセージ\n";
    TXT += " *      @param {boolean|callback} inObj.abort? - true で中止処理。callback で中止処理＆コールバック。\n";
    TXT += " *      @param {object)} inObj.style? - CSSプロパティ\n";
    TXT += " *\n";
    TXT += " ************************************************************\n";
    TXT += " *\n";
    TXT += " *  スピナーを閉じる\n";
    TXT += " *    S.destroy()\n";
    TXT += " *\n";
    TXT += " ************************************************************\n";
    console.debug(['spinner.js', 'スピナーを表示するクラス', TXT.split("\n")]);
  }

  /**
   * スピナーを表示
   *
   *  @param {string} inObj.message? - 表示するメッセージ
   *  @param {boolean|callback} inObj.abort? - true で中止処理。callback で中止処理＆コールバック。
   *  @param {object} inObj.style? - CSSプロパティ
   */
  show(inObj) {
    const elem = this.#createElement(inObj);
    document.body.appendChild(elem);
    if (typeof(inObj?.abort) == "function" || inObj?.abort === true) document.getElementById(this.id).querySelector("div.close").addEventListener("click", (...args) => this.abort(inObj?.abort));
    document.body.classList.add("noScrollY_" + this.id);
  }

  /**
   * 要素の作成
   *
   *  @param {string} inObj.message? - 表示するメッセージ
   *  @param {boolean|callback} inObj.abort? - true で中止処理。callback で中止処理＆コールバック。
   *  @param {object} inObj.style? - CSSプロパティ
   */
  #createElement(inObj) {
    this.id = this.#makeUUID();
    const elem = document.createElement("div");
    elem.classList.add("spinnerWrap");
    elem.innerHTML = this.#makeHtml(inObj);
    elem.id = this.id;
    elem.appendChild(this.#makeCSS());
    if (typeof(inObj?.style) == "object") Object.assign(elem.style, inObj.style);
    return elem;
  }

  /**
   * UUIDを作成
   *  @return {string}
   */
  #makeUUID() {
    return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c){
      let r = Math.random() * 16 | 0, v = c == "x" ? r : r & 3 | 8;
      return v.toString(16);
    });
  }

  /**
   * HTMLを作成
   *
   *  @param {string} inObj.message? - 表示するメッセージ
   *  @param {boolean|callback} inObj.abort? - true で中止処理。callback で中止処理＆コールバック。
   *  @param {object} inObj.style? - CSSプロパティ
   */
  #makeHtml(inObj) {
    let html = "";
    html += "<div class=\"animationWrap\">";
    html += " <div class=\"dotWrap\">";
    html += "  <div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div>";
    html += " </div><!-- END div.dotWrap -->";
    if (typeof(inObj?.message) == "string") html += " <div class=\"message\">" + inObj.message + "</div>";
    html += "</div><!-- END div.animationWrap -->";
    if (typeof(inObj?.abort) == "function" || inObj?.abort === true) html += "<div class=\"close\"></div>";
    return html;
  }

  /**
   * スタイルシートを作成
   *
   *  @return {element} - style
   */
  #makeCSS() {
    const style = document.createElement("style");
    style.textContent = `
      div.spinnerWrap {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 10000;
        width: 100vw;
        height: 100vh;
        background-color: rgba(0, 0, 0, .6);
        cursor: default;
      }
      div.spinnerWrap > div.animationWrap {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        text-align: center;
        color: #fff;
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap {
        display: inline-block;
        margin: auto;
        position: relative;
        animation-name: spinner;
        animation-duration: 2s;
        animation-timing-function: steps(120, start);
        animation-iteration-count: infinite;
        animation-delay: 0s;
      }
      @keyframes spinner{
          0%{ transform: rotate(  0deg); }
        100%{ transform: rotate(360deg); }
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div {
        display: inline-block;
        width: 20%;
        height: 20%;
        background-color: white;
        border-radius: 50%;
        position: absolute;
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div:nth-child(1) {
        top: 0;
        left: 50%;
        transform: translateX(-50%);
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div:nth-child(2) {
        top: 15%;
        left: 85%;
        transform: translate(-85%, -15%);
        opacity: .3;
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div:nth-child(3) {
        top: 50%;
        left: 100%;
        transform: translate(-100%, -50%);
        opacity: .4;
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div:nth-child(4) {
        top: 85%;
        left: 85%;
        transform: translate(-85%, -85%);
        opacity: .5;
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div:nth-child(5) {
        top: 100%;
        left: 50%;
        transform: translate(-50%, -100%);
        opacity: .6;
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div:nth-child(6) {
        top: 85%;
        left: 15%;
        transform: translate(-15%, -85%);
        opacity: .7;
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div:nth-child(7) {
        top: 50%;
        left: 0%;
        transform: translate(0, -50%);
        opacity: .8;
      }
      div.spinnerWrap > div.animationWrap > div.dotWrap > div:nth-child(8) {
        top: 15%;
        left: 15%;
        transform: translate(-15%, -15%);
        opacity: .9;
      }

      div.spinnerWrap > div.animationWrap > div.message {
        padding: 1em;
      }

      div.spinnerWrap > div.close {
        position: fixed;
        top: 1em;
        right: 1em;
        display: inline-block;
        width: 2em;
        height: 2em;
        cursor: pointer;
      }
      div.spinnerWrap > div.close::before,
      div.spinnerWrap > div.close::after {
        content: "";
        display: inline-block;
        width: 2em;
        height: .4em;
        background-color: #fff;
        position: absolute;
        top: 50%;
        left: 50%;
      }
      div.spinnerWrap > div.close::before {
        transform: translate(-50%, -50%) rotate(45deg);
      }
      div.spinnerWrap > div.close::after {
        transform: translate(-50%, -50%) rotate(-45deg);
      }

      @media print, screen and (min-width: 1025px) {
        div.spinnerWrap > div.animationWrap {
          width: 50vw;
        }
        div.spinnerWrap > div.animationWrap > div.dotWrap {
          width: 5vw;
          height: 5vw;
        }
        div.spinnerWrap > div.animationWrap > div.message {
          font-size: 18px;
        }
      }
      @media screen and (min-width: 641px) and (max-width: 1024px) {
        div.spinnerWrap > div.animationWrap {
          width: 70vw;
        }
        div.spinnerWrap > div.animationWrap > div.dotWrap {
          width: 8vw;
          height: 8vw;
        }
        div.spinnerWrap > div.animationWrap > div.message {
          font-size: 2.1077vw;
        }
      }
      @media screen and (max-width: 640px) {
        div.spinnerWrap > div.animationWrap {
          width: 80vw;
        }
        div.spinnerWrap > div.animationWrap > div.dotWrap {
          width: 15vw;
          height: 15vw;
        }
        div.spinnerWrap > div.animationWrap > div.message {
          font-size: 4.5vw;
        }
      }

      body[class*="noScrollY"] {
        overflow-y: hidden;
      }
    `;
    return style;
  }

  /**
   * スピナーを非表示
   */
  destroy() {
    const elem = document.getElementById(this.id);
    if (elem) document.getElementById(this.id).remove();
    document.body.classList.remove("noScrollY_" + this.id);
  }

  /**
   * 閉じる
   */
  abort(abort) {
    this.destroy();
    if (typeof(abort) == "function") abort();
  }
  
}
new Spinner().help();