;
/*************************************************************
 *
 * Copyright (c) 2026 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2026 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update		: 2026.02.06
 *
 ************************************************************/
'use strict';

(() => {
  /* =========================================================
   * 定数・グローバル変数
   * ========================================================= */
  const pollingStartEl = document.getElementById("pollingStart");
  const pollingStopEl = document.getElementById("pollingStop");

  let YP = null;
  
  
  /* =========================================================
   * 初期処理
   * ========================================================= */
  document.addEventListener('DOMContentLoaded', onLoaded);
  pollingStartEl.addEventListener("click", clickPollingStart);
  pollingStopEl.addEventListener("click", clickPollingStop);
  
  
  /**
   * DOMツリー読み込み完了後に実行
   */
  function onLoaded () {
    YP = new YsPasori();
  }
  
  
  /* =========================================================
   * メイン処理
   * ========================================================= */

  async function clickPollingStart() {
    pollingStartEl.classList.add('disabled');
    pollingStartEl.disabled = true;
    pollingStopEl.classList.remove('disabled');
    pollingStopEl.disabled = false;

    await YP.connectUsbDevice();
    const ID = await YP.startPolling();
    if (ID) alert(ID);

    clickPollingStop();
  }


  async function clickPollingStop() {
    YP.stopPolling();

    pollingStartEl.classList.remove('disabled');
    pollingStartEl.disabled = false;
    pollingStopEl.classList.add('disabled');
    pollingStopEl.disabled = true;
  }
  
  
  /* =========================================================
   * ユーティリティ関数
   * ========================================================= */
})();