;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	  : 2025.10.06
 *
 ************************************************************/
'use strict';

/**
 * シングルタスク
 */
function oneTask () {
  const MT = new MultiTask();
  MT.execute([
    [
      { func:_one, html:'一つ目の関数を実行しています。' },
      { func:_two, html:'二つ目の関数を実行しています。' },
      { func:_three, html:'三つ目の関数を実行しています。', args:{ title: '三つ目の関数が実行されました。' } },
    ]
  ]);
}
function _one () {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      console.log('一つ目の関数が実行されました。');
      resolve(true);
    }, 1000);
  });
}
function _two () {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      console.log('二つ目の関数が実行されました。');
      resolve(false);
    }, 1500);
  });
}
function _three (args) {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      console.log(args.title);
      resolve();
    }, 1500);
  });
}

/**
 * マルチタスク
 */
function twoTask () {
  const MT = new MultiTask();
  MT.execute([
    [
      { func:_one, html:'一つ目の関数を実行しています。' },
      { func:_two, html:'二つ目の関数を実行しています。' },
      { func:_three, html:'三つ目の関数を実行しています。', args:{ title: '三つ目の関数が実行されました。' } },
    ],
    [
      { func:_Alpha, html:'Alphaの関数を実行しています。' },
      { func:_Beta, html:'Betaの関数を実行しています。' },
      { func:_Gamma, html:'Gammaの関数を実行しています。' },
    ]
  ]);
}
function _Alpha () {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      console.log('Alphaの関数が実行されました。');
      resolve(true);
    }, 1500);
  });
}
function _Beta () {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      console.log('Betaの関数が実行されました。');
      resolve(true);
    }, 1500);
  });
}
function _Gamma () {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      console.log('Gammaの関数が実行されました。');
      resolve(true);
    }, 1000);
  });
}

/**
 * 中断機能付き
 */
function abortTask () {
  const MT = new MultiTask(true);
  MT.execute([
    [
      { func:_one, html:'一つ目の関数を実行しています。' },
      { func:_one, html:'二つ目の関数を実行しています。' },
      { func:_one, html:'三つ目の関数を実行しています。' },
      { func:_one, html:'四つ目の関数を実行しています。' },
      { func:_one, html:'五つ目の関数を実行しています。' },
      { func:_one, html:'六つ目の関数を実行しています。' },
    ]
  ]);
}

/**
 * 中断コールバック付き
 */
function abortCallbackTask () {
  const MT = new MultiTask(abortCallbackTaskCb);
  MT.execute([
    [
      { func:_one, html:'一つ目の関数を実行しています。' },
      { func:_one, html:'二つ目の関数を実行しています。' },
      { func:_one, html:'三つ目の関数を実行しています。' },
      { func:_one, html:'四つ目の関数を実行しています。' },
      { func:_one, html:'五つ目の関数を実行しています。' },
      { func:_one, html:'六つ目の関数を実行しています。' },
    ]
  ]);
}
function abortCallbackTaskCb (arg) {
  alert('中断されました');
  console.debug('next task', arg);
}