;
/*************************************************************
 *
 * Copyright (c) 2026 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2026 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update		: 2026.03.03
 *
 ************************************************************/
'use strict';

class Hint {
  #ID = "hint-style";
  #styleElement;
  #hintBox;

  constructor (...args) {
    if (args[0] === "help") return;

    // スタイルシートを適用
    this.#injectStyle();
    // ヒントボックスの作成
    this.#createHintBox();
  }

  help() {
    let TXT = " ************************************************************\n";
    TXT += " *\n";
    TXT += " *  Copyright (c) 2026 ysrock Co., Ltd. <info@ysrock.co.jp>\n";
    TXT += " *  Copyright (c) 2026 Yasuo Sugano <sugano@ysrock.co.jp>\n";
    TXT += " *\n";
    TXT += " *  Version : 1.0.0\n";
    TXT += " *  Update  : 2026.03.03\n";
    TXT += " *\n";
    TXT += " ************************************************************\n";
    TXT += " *\n";
    TXT += " *  マウスオーバーでヒントを表示させる\n";
    TXT += " *    const H = new Hint()\n";
    TXT += " *\n";
    TXT += " ************************************************************\n";
    TXT += " *\n";
    TXT += " *  要素にイベントを付与\n";
    TXT += " *    H.attachEvents(elements);\n";
    TXT += " *      @param {HTMLElement[]} elements\n";
    TXT += " *\n";
    TXT += " ************************************************************\n";
    console.debug(['hint.js', 'ヒントを表示するクラス', TXT.split("\n")]);
  }


  attachEvents (elements) {
    if (!elements) return;
    elements = this.#normalizeElements(elements);

    elements.forEach(el => {
      el.classList.add('hint-target');
      el.addEventListener('mousemove', (e) => {
        this.#showHint(e, el);
      });
      el.addEventListener('mouseleave', () => {
        this.#hideHint();
      });
    });

  }


  /**
   * 配列に統一
   *  @param value
   */
  #normalizeElements (value) {
    if (value instanceof Element) {
      return [value];
    }

    if (value instanceof NodeList || value instanceof HTMLCollection) {
      return Array.from(value);
    }

    throw new TypeError('Element または NodeList を渡してください');
  }


  /**
   * スタイルシートを適用
   */
  #injectStyle() {
    if (document.getElementById(this.#ID)) return;

    this.#styleElement = document.createElement('style');
    this.#styleElement.id = this.#ID;
    this.#styleElement.textContent = `
      .hint-target {
        cursor: pointer;
      }

      .hint-box {
        position: fixed;
        background: #333;
        color: #fff;
        padding: 6px 10px;
        border-radius: 4px;
        font-size: 12px;
        pointer-events: none;
        z-index: 9999;
        display: none;
        white-space: nowrap;
      }
    `;
    document.head.appendChild(this.#styleElement);
  }

  /**
   * ヒントボックスの作成
   */
  #createHintBox() {
    this.#hintBox = document.createElement('div');
    this.#hintBox.className = 'hint-box';
    document.body.appendChild(this.#hintBox);
  }

  /**
   * ヒントボックスを表示
   */
  #showHint(event, element) {
    const html = element.dataset.hint || '<b>data-hintが未設定です</b>';
    this.#hintBox.innerHTML = html;
    this.#hintBox.style.left = event.clientX + 10 + 'px';
    this.#hintBox.style.top = event.clientY + 10 + 'px';
    this.#hintBox.style.display = 'block';
  }

  /**
   * ヒントボックスを非表示
   */
  #hideHint() {
    this.#hintBox.style.display = 'none';
  }

}
new Hint('help').help();