;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.1.0
 * Update	  : 2025.10.02
 *
 ************************************************************/
'use strict';
(() => {
  window.addEventListener('load', () => {
    const D = new Dialog();

    document.getElementById("normal").addEventListener("click", (e) => {
      D.open({
        header: { subject: "シンプル" },
        body: { html: "alertと同じようなスタイルです。" },
        footer: { buttons: [
          {'text': '閉じる', click: () => D.close() }
        ]}
      });
    });

    document.getElementById("twoOptions").addEventListener("click", (e) => {
      D.open({
        header: { subject: "２つの選択肢" },
        body: { html: "ボタンのクラスにblueを指定すると<br>青いボタンに変更できます。" },
        footer: { buttons: [
          {'text': 'alert', class: ['blue'], click: () => alert('alertがクリックされました') },
          {'text': '閉じる', click: () => D.close() }
        ]}
      });
    });

    document.getElementById("description").addEventListener("click", (e) => {
      D.open({
        header: { subject: "長い説明文" },
        body: { html: "説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>説明文が長いと、スクロールバーが表示されます。<br>" },
        footer: { buttons: [
          {'text': '閉じる', click: () => D.close() }
        ]}
      });
    });

    document.getElementById("confirm").addEventListener("click", (e) => {
      D.open({
        header: { subject: "確認機能付き" },
        body: { html: "閉じるボタンを押すと、ダイアログが消えます。<br><label><input type=\"checkbox\">同意しました</label>" },
        footer: { buttons: [
          {'text': '閉じる', class: ['blue'], click: () => D.close(), disabled: true }
        ]}
      });
      D.getBodyElement().querySelector('input[type=checkbox]').addEventListener("change", (e) => {
        const buttonElements = D.getButtonElements();
        buttonElements[0].disabled = !e.target.checked;
      });
    });

    document.getElementById("noButtons").addEventListener("click", (e) => {
      D.open({
        body: { html: "ボタンが無いバージョン" }
      });
    });

  });

})();