;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 0.1.4
 * Update	  : 2025.02.19
 *
 ************************************************************/
'use strict';

window.addEventListener('load', () => {
  peerClosure.ready( "parent", ICE, setupDataChannel, ConnectionStateChange );
});


function ConnectionStateChange (pc) {
  return function (evt) {
    console.debug([ 'parent/index.js', 'peerClosure.ConnectionStateChange', evt, pc.connectionState ]);
    if (pc.connectionState == "connected") {
      // 相手と接続した時の処理
      document.getElementById("sendText").disabled = false;
      document.getElementById("buttonSubmit").disabled = false;
      document.getElementById("recvText").disabled = false;
      return;
    };
    if (pc.connectionState == "disconnected") {
      // 相手と切断した時の処理
      location.reload();
      return;
    };
  };
};
  

function setupDataChannel (dc) {
  dc.onerror = (e) => console.debug([ 'parent/index.js', 'setupDataChannel onerror', e ]);
  dc.onmessage = (e) => {
    console.debug([ 'parent/index.js', 'setupDataChannel onmessage', e ]);
    // メッセージを受信した時の処理
    document.getElementById("recvText").value = "> " + e.data + "\n" + document.getElementById("recvText").value;
  };
  dc.onopen = (e) => console.debug([ 'parent/index.js', 'setupDataChannel onopen', e ]);
  dc.onclose = (e) => {
    console.debug([ 'parent/index.js', 'setupDataChannel onclose', e ]);
    // 相手と切断した時の処理
    location.reload();
  };
};


const sendExecute = function () {
  const msg = document.getElementById('sendText').value;
  document.getElementById('sendText').value = "";
  document.getElementById("recvText").value = msg + "\n" + document.getElementById("recvText").value;
  peerClosure.send(msg);
};
