;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 0.1.3
 * Update	  : 2025.02.19
 *
 ************************************************************/
'use strict';
(() => {
  window.addEventListener('load', () => {
    vueClosure.ready();
  });
  
  /**
   * Vue
   */
  const vueClosure = (() => {
    return{
      vueApp: null,

      ready: () => {
        vueClosure.vueApp = vueClosure.create();
      },
      create: () => {
        return Vue.createApp({
          setup() {
            /********** イベント **********/
            const peerSend = (...args) => peerClosure.send(...args);

            /********** リファレンス **********/

            /********** 定数 **********/

            /********** 変数 **********/
            const connection = Vue.ref(false);
            const sendMessage = Vue.ref("");
            const recvMessage = Vue.ref("");


            peerClosure.waitSDP();


            return {
              peerSend,

              connection,
              sendMessage,
              recvMessage,
            };
          },
          components: {
          }
        }).mount('#main');
      },

    }
  })();


  /**
   * peerClosure
   */
  const peerClosure = (() => {
    return {
      timerId: null,
      peerConnection: null,
      peerConnectionConfig: () => {
        return {
          'iceServers': [
            { urls: "stun:stun.l.google.com:19302" },
            { urls: "stun:stun.l.google.com:5349" },
            { urls: "stun:stun1.l.google.com:3478" },
            { urls: "stun:stun1.l.google.com:5349" },
            { urls: "stun:stun2.l.google.com:19302" },
            { urls: "stun:stun2.l.google.com:5349" },
            { urls: "stun:stun3.l.google.com:3478" },
            { urls: "stun:stun3.l.google.com:5349" },
            { urls: "stun:stun4.l.google.com:19302" },
            { urls: "stun:stun4.l.google.com:5349" }
          ]
        };
      },


      waitSDP: function() {
        this.timerId = setTimeout(async() => {
          const resultObj = await this.readSDP();
          if (resultObj !== null && 'parent' in resultObj !== false && resultObj.parent) this.setSDP(resultObj.parent);
          else this.waitSDP();
        }, 1000);
      },
      readSDP: () => {
        return new Promise((resolve, reject) => {
          fetch("../read.php", {
            method: 'GET',
            headers: { "Content-Type": "application/json" },
          }).then(res => {
            if (!res.ok) throw new Error("Network response was not ok.");
            return res.json();
          }).then((json) => {
            resolve(json === null ? null : JSON.parse(json));
          }).catch(err => {
            console.error([ 'child/index.js', 'fetch', err ]);
            reject(err);
          });
        });
      },


      setSDP: function(SDPText) {
        let offer = new RTCSessionDescription({
          type: 'offer',
          sdp: SDPText,
        });
        // 新しい RTCPeerConnection を作成する
        this.peerConnection = this.createPeerConnection(SDPText);
        this.peerConnection.setRemoteDescription(offer).then(function() {
          console.debug('setRemoteDescription() succeeded.');
        }).catch(function(err) {
          console.error('setRemoteDescription() failed.', err);
        });
        this.peerConnection.createAnswer().then((sessionDescription) => {
          console.debug('createAnswer() succeeded.');
          return this.peerConnection.setLocalDescription(sessionDescription);
        }).then(function() {
          console.debug('setLocalDescription() succeeded.');
        }).catch(function(err) {
          console.error('setLocalDescription() failed.', err);
        });
      },


      /**
       * 新しい RTCPeerConnection を作成する
       */
      createPeerConnection: function (SDPText) {
        let pc = new RTCPeerConnection(this.peerConnectionConfig);
        pc.onicecandidate = this.ICEcandidate(pc, SDPText);
        pc.onconnectionstatechange = this.ConnectionStateChange(pc);
        pc.ondatachannel  = this.DataChannel();
        return pc;
      },
      ICEcandidate: function (pc, SDPText) {
        return async (evt) => {
          if (evt.candidate) {
            console.debug([ 'child/index.js', 'peerClosure.ICEcandidate', 'Collecting ICE candidates', evt.candidate ]);
            return;
          };
          console.debug([ 'child/index.js', 'pc.localDescription.sdp', pc.localDescription.sdp ]);
          const saveResult = await  this.SaveSDP({parent:SDPText, child:pc.localDescription.sdp});
          console.debug([ 'child/index.js', 'ICEcandidate saveResult', saveResult ]);
        };
      },
      ConnectionStateChange: (pc) => {
        return function (evt) {
          console.debug([ 'child/index.js', 'peerClosure.ConnectionStateChange', evt, pc.connectionState ]);
          if (pc.connectionState == "connected") {
            vueClosure.vueApp.connection = true;
            return;
          };
          if (pc.connectionState == "disconnected") {
            location.reload();
            return;
          };
        };
      },
      DataChannel: () => {
        return function (evt) {
          // console.debug([ 'src/index.js', 'peerClosure.DataChannel', evt ]);
          peerClosure.setupDataChannel(evt.channel);
          peerClosure.dataChannel = evt.channel;
        };
      },
      setupDataChannel: function (dc) {
        dc.onerror = (e) => console.debug([ 'child/index.js', 'peerClosure.setupDataChannel onerror', e ]);
        dc.onmessage = (e) => {
          console.debug([ 'child/index.js', 'peerClosure.setupDataChannel onmessage', e ]);
          vueClosure.vueApp.recvMessage = "> " + e.data + "\n" + vueClosure.vueApp.recvMessage;
        };
        dc.onopen = (e) => console.debug([ 'child/index.js', 'peerClosure.setupDataChannel onopen', e ]);
        dc.onclose = (e) => {
          console.debug([ 'child/index.js', 'peerClosure.setupDataChannel onclose', e ]);
          location.reload();
        };
      },
      SaveSDP: (SDP) => {
        return new Promise((resolve, reject) => {
          fetch("../save.php", {
            method: 'POST',
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(SDP)
          }).then(res => {
            if (!res.ok) throw new Error("Network response was not ok.");
            return res.json();
          }).then((json) => {
            resolve(json);
          }).catch(err => {
            console.error([ 'child/index.js', 'fetch', err ]);
            reject(err);
          });
        });
      },


      send: function () {
        if (!this.peerConnection || this.peerConnection.connectionState != 'connected') {
          console.error('PeerConnection is not established.');
          return false;
        };
        const msg = vueClosure.vueApp.sendMessage;
        vueClosure.vueApp.sendMessage = "";
        vueClosure.vueApp.recvMessage = msg + "\n" + vueClosure.vueApp.recvMessage;
        this.dataChannel.send(msg);
      },


    }
  })();



})();