;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 0.1.2
 * Update	  : 2025.01.16
 *
 ************************************************************/
'use strict';
(() => {
  window.addEventListener('load', () => {
    vueClosure.ready();
  });
  
  /**
   * Vue
   */
  const vueClosure = (() => {
    return{
      vueApp: null,
      ready: () => {
        vueClosure.vueApp = vueClosure.create();
      },
      create: () => {
        return Vue.createApp({
          setup() {

            /***** 定数 *****/
            const signalingCount = 3;


            /**
             * 関数：シグナリングする端末分の初期化
             *  @param count (int) 端末数
             */
            const setInitialSignaling = (count) => {
              signalingAry.value = [];
              for (let i=0; i<count; i++) {
                signalingAry.value.push({
                  offer: null,
                  answer: null,
                  connected: false
                });
              };
            };


            /***** ここから *****/

            const signalingAry = Vue.ref([]);
            setInitialSignaling(signalingCount);

            return {
              signalingAry,
            };



          },
          components: {
          }
        }).mount('#main');
      }
    }
  })();

})();