;
/*************************************************************
 *
 * Copyright (c) 2025 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2025 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 0.1.0
 * Update	  : 2025.01.14
 *
 ************************************************************/
'use strict';
(() => {
  window.addEventListener('load', () => {
    vueClosure.ready();
  });
  
  /**
   * Vue
   */
  const vueClosure = (() => {
    return{
      vueApp: null,
      ready: () => {
        vueClosure.vueApp = vueClosure.create();
      },
      create: () => {
        return Vue.createApp({
          setup() {
            const sendTo = Vue.ref(false);

            const signalingCount = 2;
            const signalingAry = Vue.ref([]);
            for (let i=0; i<signalingCount; i++) {
              signalingAry.value.push({
                offer: null,
                answer: null,
                connected: false
              });
            };

            const setOffer = (idx, sdp) => signalingAry.value[idx] = { offer: sdp, answer: null, connected: false};
            const getJSON = () => signalingAry.value;

            // Offerの作成
            for (let i=0, len=signalingAry.value.length; i<len; i++) peerClosure.makeOffer(i);



            return {
              sendTo,
              signalingAry,
              setOffer,
              getJSON,
            };
          },
          components: {
          }
        }).mount('#main');
      }
    }
  })();


  /**
   * peerClosure
   */
  const peerClosure = (() => {
    return {
      dataChannel: null,
      makeOffer: function (offerIdx) {
        // 新しい RTCPeerConnection を作成する
        let peerConnection = this.createPeerConnection(offerIdx);
        // Data channel を生成
        this.dataChannel = peerConnection.createDataChannel("dataChannel", { ordered: false });
        peerClosure.setupDataChannel(this.dataChannel);
        // Offer を生成する
        peerConnection.createOffer().then(function (sessionDescription) {
          console.debug([ 'src/index.js', 'createOffer() succeeded.' ]);
          return peerConnection.setLocalDescription(sessionDescription);
        }).then(function () {
          console.debug([ 'src/index.js', 'setLocalDescription() succeeded.' ]);
        }).catch(function (err) {
          console.error("setLocalDescription() failed.", err);
        });
      },
      createPeerConnection: function (offerIdx) {
        let pc = new RTCPeerConnection(this.peerConnectionConfig);
        pc.onicecandidate = this.ICEcandidate(pc, offerIdx);
        pc.onconnectionstatechange = this.ConnectionStateChange(pc);
        pc.ondatachannel  = this.DataChannel();
        return pc;
      },

      peerConnectionConfig: () => {
        return {
          'iceServers': [
            { urls: "stun:stun.l.google.com:19302" },
            { urls: "stun:stun.l.google.com:5349" },
            { urls: "stun:stun1.l.google.com:3478" },
            { urls: "stun:stun1.l.google.com:5349" },
            { urls: "stun:stun2.l.google.com:19302" },
            { urls: "stun:stun2.l.google.com:5349" },
            { urls: "stun:stun3.l.google.com:3478" },
            { urls: "stun:stun3.l.google.com:5349" },
            { urls: "stun:stun4.l.google.com:19302" },
            { urls: "stun:stun4.l.google.com:5349" }
          ]
        };
      },
      ICEcandidate: (pc, offerIdx) => {
        return function (evt) {
          if (evt.candidate) {
            console.debug([ 'src/index.js', 'peerClosure.ICEcandidate', 'Collecting ICE candidates', evt.candidate ]);
            return;
          };
          console.debug([ 'src/index.js', 'peerClosure.ICEcandidate', 'sdp', pc.localDescription.sdp ]);
          console.log('Vanilla ICE ready');
          vueClosure.vueApp.setOffer(offerIdx, pc.localDescription.sdp);
          peerClosure.SaveSDP(vueClosure.vueApp.getJSON());
        };
      },
      ConnectionStateChange: (pc) => {
        return function (evt) {
          console.debug([ 'src/index.js', 'peerClosure.ConnectionStateChange', evt, pc.connectionState ]);
          // if (pc.connectionState == "connected") {
          //   document.getElementById('messageForm').disabled = false;
          //   document.getElementById('sendButton').classList.remove('disabled');
          //   document.getElementById('sendButton').disabled = false;
          // };
        };
      },
      DataChannel: () => {
        return function (evt) {
          console.debug([ 'src/index.js', 'peerClosure.DataChannel', evt ]);
          peerClosure.setupDataChannel(evt.channel);
          peerClosure.dataChannel = evt.channel;
        };
      },
      setupDataChannel: function (dc) {
        dc.onerror = (e) => console.debug([ 'src/index.js', 'peerClosure.setupDataChannel onerror', e ]);
        dc.onmessage = (e) => console.debug([ 'src/index.js', 'peerClosure.setupDataChannel onmessage', e ]);
        dc.onopen = (e) => console.debug([ 'src/index.js', 'peerClosure.setupDataChannel onopen', e ]);
        dc.onclose = (e) => console.debug([ 'src/index.js', 'peerClosure.setupDataChannel onclose', e ]);
      },
      SaveSDP: (SDPJSON) => {
        return new Promise((resolve, reject) => {
          fetch("index_save.php", {
            method: 'POST',
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(SDPJSON)
          }).then(res => {
            if (!res.ok) throw new Error("Network response was not ok.");
            console.debug([ 'src/index.js', 'fetch', res ]);
            console.log('SDP saved.');
            resolve(res);
          }).catch(err => {
            console.error([ 'src/index.js', 'fetch', err ]);
            reject(err);
          });
        });
      },



    }
  })();


})();