;
/*************************************************************
 *
 * Copyright (c) 2024 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2024 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	  : 2024.12.24
 *
 ************************************************************/
'use strict';
(() => {
  window.addEventListener('load', () => {
    makeOffer = (...args) => parentClosure.makeOffer(...args);
    acceptOffer = (...args) => childrenClosure.acceptOffer(...args);
    sendMessage = (...args) => commonClosure.sendMessage(...args);

  });

  let peerConnection;
  let dataChannel;


  /**
   * 親
   */
  const parentClosure = (() => {
    return{
      makeOffer: (...args) => {
        console.debug([ 'src/index.js', 'parentClosure.makeOffer', ...args ]);
        // 新しい RTCPeerConnection を作成する
        peerConnection = commonClosure.createPeerConnection('parent');
        // Data channel を生成
        dataChannel = peerConnection.createDataChannel("dataChannel_1.0.0", { ordered: false });
        commonClosure.setupDataChannel(dataChannel);
        // Offer を生成する
        peerConnection.createOffer().then(function (sessionDescription) {
          console.debug([ 'src/index.js', 'createOffer() succeeded.' ]);
          return peerConnection.setLocalDescription(sessionDescription);
        }).then(function () {
          console.debug([ 'src/index.js', 'setLocalDescription() succeeded.' ]);
        }).catch(function (err) {
          console.error("setLocalDescription() failed.", err);
        });
      },
 
    }
  })();


  /**
   * 子
   */
  const childrenClosure = (() => {
    return {
      acceptOffer: (...args) => {
        console.debug([ 'src/index.js', 'childrenClosure.acceptOffer', ...args ]);
        if (peerConnection) {
          // Peer Connection が生成済みの場合，SDP を Answer と見なす
          let answer = new RTCSessionDescription({
            type: 'answer',
            sdp: SDP
          });
          peerConnection.setRemoteDescription(answer).then(function() {
            console.log('setRemoteDescription() succeeded.');
          }).catch(function(err) {
            console.error('setRemoteDescription() failed.', err);
          });
        } else {
          // Peer Connection が未生成の場合，SDP を Offer と見なす
          let offer = new RTCSessionDescription({
            type: 'offer',
            sdp: SDP
          });
          // Peer Connection を生成
          peerConnection = commonClosure.createPeerConnection('children');
          peerConnection.setRemoteDescription(offer).then(function () {
            console.log('setRemoteDescription() succeeded.');
          }).catch(function(err) {
            console.error('setRemoteDescription() failed.', err);
          });
          // Answer を生成
          peerConnection.createAnswer().then(function(sessionDescription) {
            console.log('createAnswer() succeeded.');
            return peerConnection.setLocalDescription(sessionDescription);
          }).then(function () {
            // setLocalDescription() が成功した場合
            // Trickle ICE ではここで SDP を相手に通知する
            // Vanilla ICE では ICE candidate が揃うのを待つ
            console.log('setLocalDescription() succeeded.');
          }).catch(function(err) {
            console.error('setLocalDescription() failed.', err);
          });

        };
        
      },

    };
  })();


  /**
   * 共通
   */
  const commonClosure = (() => {
    return {
      createPeerConnection: function (relation) {
        let pc = new RTCPeerConnection(this.peerConnectionConfig);
        pc.onicecandidate = this.ICEcandidate(pc, relation);
        pc.onconnectionstatechange = this.ConnectionStateChange(pc);
        pc.ondatachannel  = this.DataChannel();
        return pc;
      },

      peerConnectionConfig: () => {
        return {
          'iceServers': [
            { urls: "stun:stun.l.google.com:19302" },
            { urls: "stun:stun.l.google.com:5349" },
            { urls: "stun:stun1.l.google.com:3478" },
            { urls: "stun:stun1.l.google.com:5349" },
            { urls: "stun:stun2.l.google.com:19302" },
            { urls: "stun:stun2.l.google.com:5349" },
            { urls: "stun:stun3.l.google.com:3478" },
            { urls: "stun:stun3.l.google.com:5349" },
            { urls: "stun:stun4.l.google.com:19302" },
            { urls: "stun:stun4.l.google.com:5349" }
          ]
        };
      },
      ICEcandidate: (pc, relation) => {
        return function (evt) {
          console.debug([ 'src/index.js', 'commonClosure.ICEcandidate', evt ]);
          if (evt.candidate) {
            console.debug([ 'src/index.js', 'commonClosure.ICEcandidate', 'Collecting ICE candidates', evt.candidate ]);
            return;
          };
          console.debug([ 'src/index.js', 'commonClosure.ICEcandidate', 'sdp', pc.localDescription.sdp ]);
          console.log('Vanilla ICE ready');
          if (relation == 'parent') commonClosure.SaveSDP(pc.localDescription.sdp);
        };
      },
      ConnectionStateChange: (pc) => {
        return function (evt) {
          console.debug([ 'src/index.js', 'commonClosure.ConnectionStateChange', evt, pc.connectionState ]);
          console.debug(pc.connectionState);
          // if (pc.connectionState == "connected") {
          //   document.getElementById('messageForm').disabled = false;
          //   document.getElementById('sendButton').classList.remove('disabled');
          //   document.getElementById('sendButton').disabled = false;
          // };
        };
      },
      DataChannel: () => {
        return function (evt) {
          console.debug([ 'src/index.js', 'commonClosure.DataChannel', evt ]);
          commonClosure.setupDataChannel(evt.channel);
          dataChannel = evt.channel;
        };
      },
      SaveSDP: (sdp) => {
        return new Promise((resolve, reject) => {
          fetch("save_parent.php", {
            method: 'POST',
            headers: { "Content-Type": "text/plain" },
            body: sdp
          }).then(res => {
            if (!res.ok) throw new Error("Network response was not ok.");
            console.debug([ 'src/index.js', 'fetch', res ]);
            console.log('SDP saved.');
            resolve(res);
          }).catch(err => {
            console.error([ 'src/index.js', 'fetch', err ]);
            reject(err);
          });
        });
      },


      setupDataChannel: function (dc) {
        dc.onerror = (e) => console.debug([ 'src/index.js', 'commonClosure.setupDataChannel onerror', e ]);
        dc.onmessage = (e) => console.debug([ 'src/index.js', 'commonClosure.setupDataChannel onmessage', e ]);
        dc.onopen = (e) => console.debug([ 'src/index.js', 'commonClosure.setupDataChannel onopen', e ]);
        dc.onclose = (e) => console.debug([ 'src/index.js', 'commonClosure.setupDataChannel onclose', e ]);
      },


      sendMessage: function (...args) {
        console.debug([ 'src/index.js', 'commonClosure.sendMessage', peerConnection.connectionState ]);
        if (!peerConnection || peerConnection.connectionState != 'connected' ) {
          console.error('PeerConnection is not established.');
          return;
        };
        const sendMessage = document.getElementById('messageForm').value;
        document.getElementById('messageForm').value = '';
        document.getElementById('messageHistory').value = 'me> ' + sendMessage + '\n' + document.getElementById('messageHistory').value;
        dataChannel.send(sendMessage);
      },

    };
  })();


})();